(function(exports) {
	var request_data = [];
	var autoupdate = true;
	var get_data_xhr = new XMLHttpRequest();
	var set_data_xhr = new XMLHttpRequest();
	var button_command_xhr = new XMLHttpRequest();
	var timeoutHandle;
	var response_values = [];
	var current_request_index = 0;
	var on_window = true;

	/*
	* data[].index = "AAAA:B", A - index, B - subindex;
	* data[].AccessType = "rw","ro","wo";
	* data[].DataType = "uint8","int16",ets. - for validation.
	*/
	exports.set_eds_object = function ()
	{
		general_od = JSON.parse(get_json());
		try {
			app_sw_od = JSON.parse(app_sw_get_json());
			eds_object = Object.assign({}, general_od, app_sw_od);
		}
		catch {
			eds_object = general_od;
		}
	}

	exports.change_autoupdate = function (state)
	{
		autoupdate = state;
	}

	exports.set_expert_page_configuration = function ()
	{
		configuration = configuration_expert;
	}

	exports.set_request_data = function (data)
	{
		request_data = data;
	}

	exports.timeHHMM = function (datetime)
	{
		var hours = datetime.getUTCHours()
		var minutes = datetime.getUTCMinutes();
		if (hours <= 9) {
			hours = "0" + hours;
		}
		if (minutes <= 9) {
			minutes = "0" + minutes;
		}
		return `${hours}:${minutes}`
	}

	exports.get_cell = function (key)
	{
		var form = $('<form>').addClass('apply_form');
		if ((request_data[key] != null) &&
			(request_data[key].DataType != null) &&
			(request_data[key].AccessType != null))
		{
			//console.log("key:"+key)
			var index = request_data[key].index.replace(":","_")

			var apply_input = $('<input type="text">');
			var apply_button = $('<div>');
			var template = "";
			var commands;
			var label;

			if (request_data[key].DataType == "boolean_type")
			{
				checkbox = $('<input type="checkbox">')
				checkbox_value = $('<div>')
				apply_input = $('<label>')

				apply_input.append(checkbox)
				apply_input.append(checkbox_value)
				apply_input.addClass('checkbox_value')
			}
			else
			{
				form.validate();
			}

			$.each(configuration.data_type_template().templates, function(template_index, template_item)
			{
				if (template_item.index == index)
				{
					template = template_item.template;
					commands = template_item.commands;
				}
			});

			if (request_data[key].AccessType.includes('w')) //write
			{
				if (template == "")
				{
					apply_input.addClass(request_data[key].DataType);
				}
				else
				{
					if (template == "password")
					{
						apply_input.attr({id: 'password', 'type':'password'});
						label = $('<label style="display:block">')
						label.append($('<input type="checkbox">').addClass('password_checkbox'))
						label.append($('<label>').text(l100n.localize_string("show_password")))
						//form.append(label)
					}
					if (template == "combobox")
					{
						apply_input = $('<select>');
						$.each(commands, function(commands_index, command_item)
						{
							var option = $('<option>');
							option.val(command_item.command);
							option.text(command_item.name);
							apply_input.append(option);
						});
					}
				}

				apply_input.addClass('item_edit_textbox');
			}

			if (request_data[key].AccessType.includes('r')) //read
			{
				if 	(request_data[key].AccessType.includes('o'))//read only
				{
					if (request_data[key].DataType == "boolean_type")
					{
						apply_input.children('input').attr({"disabled":"true"});
					}
					else
					{
						apply_input = $('<div>').attr({"tabindex":"0"});//tabindex=0 for focus
						//apply_input.children('input').attr({"readonly":"true"});
					}
				}
				apply_input.addClass('value');
			}

			if (request_data[key].AccessType.includes('w')) //write
			{
				if (request_data[key].DataType == "boolean_type")
				{
					apply_input.children('input').addClass("item_edit_cb")
					apply_input.children('input').attr({"index":index})
				}
				else
				{
					apply_button = $('<input type="submit">').addClass('item_edit_b');
					apply_button.attr({"index":index});
					apply_button.val(l100n.localize_string("apply_button"));
				}

			}

			apply_input.addClass(template);
			apply_input.attr({"tb_index":index});

			form.attr({"index":index});
			form.attr({"id":index});
			form.append(apply_input);
			form.append(apply_button);
			if (label != null)
			{
				form.append(label);
			}
		}
		else
		{
			form.addClass('empty')
		}

		return form;
	}

	exports.send_query = function()
	{
		var query;
		var j = 0;

		window.clearTimeout(timeoutHandle);
		if ((request_data.length > 0) && (current_request_index < request_data.length))
		{
			query = '/get_od_data.form?';
			for (;;)
			{
				if ((current_request_index >= request_data.length) || (j >= configuration.response_lenght()))
				{
					break;
				}

				//console.log(request_data[current_request_index])
				if (request_data[current_request_index] != null)
				{
					if (request_data[current_request_index].AccessType != null)
					{
						if (request_data[current_request_index].AccessType.includes('r')) //read
						{
							//if (request_data[current_request_index].index != null)
							if ((current_request_index > 0) && (j > 0))
				    		{
				    			query += "&";
				    		}
							query += "0x" + request_data[current_request_index].index.replace(":","_");
							j++;
						}
					}
				}

				current_request_index++;
			}

			get_data_xhr.open('GET', query, true);
			get_data_xhr.send();
		}
		//console.log(query);
	}

	exports.ip2array = function(ip_int)
	{
		var arr = []
		arr[3] = (ip_int >>> 24) & 0xFF;
		arr[2] = (ip_int >>> 16) & 0xFF;
		arr[1] = (ip_int >>> 8) & 0xFF;
		arr[0] = (ip_int >>> 0) & 0xFF;
		return arr;
	}

	function array2ip(ip_arr)
	{
		var ip = 0 >>> 0;
		var ip = ((((ip_arr[3] & 0xFF) << 24) >>> 0)
				| (((ip_arr[2] & 0xFF) << 16) >>> 0)
				| (((ip_arr[1] & 0xFF) << 8) >>> 0)
				| (((ip_arr[0] & 0xFF) << 0) >>> 0)) >>> 0;
		return ip;
	}

	function checkbox_click(checkbox)
	{
		var data = {};
		if ($(checkbox).valid())
		{
			var index_number = $(checkbox).attr('index');
			if ($(checkbox).is(':checked') == true)
			{
				new_value = "1";
			}
			else
			{
				new_value = "0";
			}

			query = '/set_od_data.form?';
			query += `0x${index_number}=${new_value}`;


			set_data_xhr.open('GET', query, true);
			set_data_xhr.send();
		}
	}

	function pass2ascii(value)
	{
		var new_value_buffer = "0x";
		for (var i = 0; i < value.length; i++)
		{
			new_value_buffer += value.charCodeAt(i).toString(16);
		}
		return new_value_buffer;
	}

	function item_edit_click(button)
	{
		$(button).addClass('edited');
		if ($(button).valid())
		{
			var index_number = $(button).attr('index');
			//alert(index_number);
			var apply_input = $(`[tb_index='${index_number}']`);
			var new_value = apply_input.val();
			//console.log("Pushed:", "`[tb_index='${index_number}']`");
			//console.log("Pushed:", apply_input);

			if (apply_input.attr('class').includes('datetime'))
			{
				//console.log(Date.parse(apply_input.val())/1000);
				//console.log(apply_input.val())
				new_value = Date.parse(apply_input.val())/1000
				/*date_string = apply_input.val();
				if (l100n.locale == "ru")
				{
					date_string = date_string.replace(/(\d{2}).(\d{2}).(\d{2})/, "$2.$1.$3");
				}
				new_value = Date.parse(date_string)/1000*/
				
				//console.log(new_value)
			}
			else if (apply_input.attr('class').includes('deadband'))
			{
				new_value = apply_input.val()*1000;
			}
			else if (apply_input.attr('class').includes('ip_addr'))
			{
				ip_str_arr = apply_input.val().split(".")
				if (ip_str_arr.length != 4) return;
				ip_int_arr = [0,0,0,0];
				for(i=0; i<4; i++)
				{
					ip_int_arr[i] = parseInt(ip_str_arr[i]);
				}
				new_value = array2ip(ip_int_arr);
			}
			else if (apply_input.attr('class').includes('password'))
			{
				new_value = pass2ascii(new_value)
				apply_input.val('');
			}
			else if (apply_input.attr('class').includes('restore_params'))
			{
				var new_value_buffer = "0x";
				for (var i = (new_value.length - 1); i >= 0; i--)
				{
				 	new_value_buffer += new_value.charCodeAt(i).toString(16);
				}
				new_value = new_value_buffer;
				apply_input.val('');
			}
			//alert(new_value);

			if ((new_value.toString() != 'NaN') && (!apply_input.attr('class').includes('error')))
			{
				//apply_input.focus()

				query = '/set_od_data.form?';
				query += `0x${index_number}=${new_value}`;

				set_data_xhr.open('GET', query, true);
				set_data_xhr.send();
			}
			else
			{
				alert(l100n.localize_string("Invalid data format."));
			}

			if (index_number == '2002_1' && new_value == '0x40000') //change pass
			{
				$("#dialog-form").dialog('open')
			}

			apply_input.removeClass('changed');
		}
	}

	function value_paste()
	{
		var new_value = 'empty'
		$(".value").each(function(index, item)
		{
			//console.log(index)
			if (index in response_values)
			{
				new_value = response_values[index].replace(/\u0000/g, '');
				/*float_value = parseFloat(new_value)
				if ((float_value.toString() != 'NaN'))
				{
					new_value = float_value;
				}*/

				if ($(item).attr('class').includes('checkbox_value'))
				{
					if (new_value == "1")
					{
						$(item).children('input').attr('checked', true);
					}
					else
					{
						$(item).children('input').attr('checked', false);
					}
				}

				if ($(item).attr('class').includes('change_value'))
				{
					$.each(configuration.data_type_template().templates, function(template_index, template_item)
					{
						if (template_item.index == $(item).attr('tb_index'))
						{
							$.each(template_item.commands, function(command_index, command_item)
							{
								if (command_item.raw_value == new_value)
								{
									new_value = command_item.new_value
								}
							});
						}
					});
				}
				else if ($(item).attr('class').includes('datetime'))
				{
					var datetime_int = parseInt(response_values[index].replace(/\u0000/g, ''));
					var subseconds = parseInt(datetime_int / Math.pow(2,32));
					var datetime = new Date((datetime_int - subseconds*Math.pow(2,32))*1000 + subseconds);

					//new_value = datetime.toLocaleString(l100n.locale);
					new_value = datetime.toISOString();
					//console.log(l100n.locale)
				}
				else if ($(item).attr('class').includes('time'))
				{
					var datetime_int = parseInt(response_values[index].replace(/\u0000/g, ''));
					var subseconds = parseInt(datetime_int / Math.pow(2,32));
					var datetime = new Date((datetime_int - subseconds*Math.pow(2,32))*1000 + subseconds);

					new_value = exports.timeHHMM(datetime)
				}
				else if ($(item).attr('class').includes('deadband'))
				{
					new_value = new_value/1000;
				}
				else if ($(item).attr('class').includes('ip_addr'))
				{
					ip_arr = exports.ip2array(new_value);
					str_ip = "";

					str_ip += ip_arr[0].toString();
					str_ip += '.';
					str_ip += ip_arr[1].toString();
					str_ip += '.';
					str_ip += ip_arr[2].toString();
					str_ip += '.';
					str_ip += ip_arr[3].toString();
					new_value = str_ip;
				}
				else if ($(item).attr('class').includes('checkbox_value'))
				{
					$.each(configuration.default_checkbox_values(), function(command_index, command_item)
					{
						if (command_item.raw_value == new_value)
						{
							new_value = command_item.new_value
						}
					});
				}


				if ($(item).attr('class').includes('checkbox_value'))
				{
					$(item).children('div').text(new_value);
				}
				else if (!$(item).attr('class').includes('changed'))//!$(item).is(":focus") ||
				{
					//console.log($(item).is("div"))
					if (!$(item).is("div"))
					{
						$(item).val(new_value);
					}
					else
					{
						$(item).text(new_value);
						$(item).trigger('value_loaded');
					}
				}
			}
		});
	}

	function autoupdate_off()
	{
		//window.clearTimeout(timeoutHandle);
		autoupdate = false;

		$('.autoupdate').addClass("off");
	}

	function autoupdate_on()
	{
		autoupdate = true;
		set_timeout_handle()

		$('.autoupdate').removeClass("off");
	}

	function set_timeout_handle()
	{
		if (autoupdate && on_window)
		{
			//console.log(timeoutHandle)
			timeoutHandle = setTimeout(exports.send_query, configuration.queryTimeout());
		}
	}

	get_data_xhr.onreadystatechange = function()
	{
		//console.log(get_data_xhr.readyState);
		if (get_data_xhr.readyState == 4)
		{
			if (get_data_xhr.status == 200)
			{
				var responseLines = get_data_xhr.responseText.split('\n');
				var responseLine = responseLines[1];
				//console.log("responseLine:"+responseLine);
				if ((responseLines[1].search( />>>ERROR<<</i ) != -1) || (responseLines[1].search( /!!!ERROR!!!/i ) != -1))
				{
					alert(l100n.localize_string("response error"));// + responseLine);
					autoupdate_off()
				}

				response_values = response_values.concat(responseLine.split('&#&'));
				response_values.pop();
				//console.log('response_values: ' + response_values);

				if (current_request_index >= (request_data.length))
				{
					value_paste();
					//t1 = performance.now();
					//console.log('Took', (t1 - t0).toFixed(4));

					current_request_index = 0;
					response_values = [];
					set_timeout_handle()
				}
				else if (request_data != null)
				{
					exports.send_query();
				}
			}
			else
			{
				alert(l100n.localize_string("Check device connection..."));
				autoupdate_off()
				current_request_index = 0;
			}
		}
	}

	set_data_xhr.onreadystatechange = function()
	{
		//console.log(set_data_xhr);
		if (set_data_xhr.readyState == 4)
		{
			if (set_data_xhr.status == 200)
			{
				var responseLines = set_data_xhr.responseText.split('\n');
				var responseLine = responseLines[1];
				var url = new URL(set_data_xhr.responseURL)
				urlSearch = url.search.slice(1)
				params = new URLSearchParams(urlSearch)

				if (params.has('0x2002_1')) //command
				{
					/*if (responseLines[1].includes('!!!ERROR!!!'))
					{
						alert('ACCESS DENIED');
					}
					else
					{
						alert('ACCESS LEVEL CHANGED');
					}*/
				}
				else if (params.has('0x2002_2')) //password
				{
					if (responseLines[1].includes('!!!ERROR!!!'))
					{
						alert(l100n.localize_string('ACCESS DENIED'));
					}
					else
					{
						alert(l100n.localize_string('ACCESS CONFIRMED'));
					}
				}
				else
				{
					//console.log("responseLine:"+responseLine);
					if ((responseLines[1].search( />>>ERROR<<</i ) != -1) || (responseLines[1].search( /!!!ERROR!!!/i ) != -1))
					{
						alert(l100n.localize_string("response error"));//: ' + responseLine);
					}
				}
			}
			else
			{
				alert(l100n.localize_string("Check device connection..."));
			}
		}
	}

	function change_password()
	{
		if ($('#password_confirm').val() != $('#password_confirm2').val())
		{
			alert(l100n.localize_string('Passwords are different.'))
		}
		else if ($('#password_confirm').attr('class').includes('error') &&
			$('#password_confirm2').attr('class').includes('error'))
		{
			alert(l100n.localize_string("Invalid data format."));
		}
		else
		{
			var index_number = '2002_2';
			var new_value = pass2ascii($('#password_confirm').val())
			var query = '/set_od_data.form?';
			query += `0x${index_number}=${new_value}`;

			set_data_xhr.open('GET', query, true);
			set_data_xhr.send();
			alert(l100n.localize_string('Password are changed.'))
			$('#password_confirm').val('')
			$('#password_confirm2').val('')
			dialog.dialog("close");
		}
	}

	$(document).ready(function()
	{
		l100n.show_locale()
		var dialog = $('<div id="dialog-form">').attr('title', l100n.localize_string("Change password."));
		var form = $('<form>')
		form.append($('<input type="password" class="password" name="password" id="password_confirm" value="">'))
		form.append($('<label>\u00A0</label>'))
		form.append($('<input type="password" class="password" name="password2" id="password_confirm2" value="">'))
		form.append($('<label>\u00A0</label>'))
		form.append($('<input type="submit" tabindex="-1" style="position:absolute; top:-1000px">'))
		form.validate()
		dialog.append(form)
		dialog.dialog({
			//height: 151,
			//width: 233,
			autoOpen: false,
			modal: true,
			position: { my: "left top", at: "right top", of: "#2002_1" },
			buttons: [{
					text: l100n.localize_string("Ok"),
					click: change_password},
				{
					text: l100n.localize_string("Cancel"),
					click: function() {
						$(this).dialog("close");}
				}]
		});
		$('.ui-dialog-titlebar-close').hide()
		form = dialog.find( "form" ).on( "submit", function( event ) {
			event.preventDefault();
			change_password();
		});

		var system_time_setting_button = ($(`<input type="submit" value="${l100n.localize_string("set system time")}" id="system_time_setting_button">`))
		$("#system_time_setting").append(system_time_setting_button)

		$(document).on('click', '#system_time_setting_button', function()
		{
			if (confirm(l100n.localize_string("system_time_setting_confirm_question")))
			{
				var value = Date.now()/1000
				var query = `/set_od_data.form?0x2081_1=${value}`;
				button_command_xhr.open('GET', query, true);
				button_command_xhr.send();
			}
		});

		$(document).on('click', '.item_edit_b', function()
		{
		    item_edit_click(this);
		});

		$(document).on('click', '.item_edit_cb', function()
		{
		    checkbox_click(this);
		});

		$(document).on('submit', '.apply_form', the_event =>
		{
			the_event.preventDefault();
			the_event.stopImmediatePropagation();
		});

		$(document).on('click', '.autoupdate', function()
		{
		    if (autoupdate)
		    {
		    	window.clearTimeout(timeoutHandle);
		    	autoupdate_off()
		    }
		    else
		    {
		    	autoupdate_on()
		    }
		});

		/*$(document).on('click', '.language', function()
		{
			l100n.change_locale()
			//l100n.show_locale()
		});*/

		$(window).focus(function() //Во вкладке
		{
			on_window = true;
			set_timeout_handle()
		});

		$(window).blur(function() //Покинули вкладку
		{
			on_window = false;
		});

		$(document).on('focus', '.value', function()
		{
			//console.log($(this).attr('class'));
			$(this).addClass("changed");
		});

		$(document).on('blur', 'div.value', function()//only readonly elements
		{
			$(this).removeClass("changed");
		});

		$(document).on('blur', '.datetime', function()//only readonly elements
		{
			$(this).removeClass("changed");
		});

		$(document).on('click', '.password_checkbox', function()
		{
			if ($(this).is(':checked')){
				$('.password').attr('type', 'text');
			} else {
				$('.password').attr('type', 'password');
			}
		});
	});
})(this.get_set_value = {});

$.validator.addMethod("password", function(value, element)
{
	var re = new RegExp("^[0-9'.\\s]{4}$");
    return this.optional(element) || re.test(value);
}, l100n.localize_string("validator_pass"));

$.validator.addMethod("ip_addr", function(value, element)
{
	var re = new RegExp("^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    return this.optional(element) || re.test(value);
}, l100n.localize_string("ip_address_pass"));

var rule = "^((0x)?[a-fA-F0-9]+)|(-?\\d+(\\.\\d{0,})?)$";
$.validator.addMethod("hex_dec_number", function(value, element)
{
    var re = new RegExp(rule);
    return this.optional(element) || re.test(value);
}, l100n.localize_string("hex_dec_number"));

$.validator.addMethod("range_localization", function(value, element, params)
{
    return this.optional(element) || (value >= params[0] && value <= params[1]);
}, jQuery.validator.format(l100n.localize_string("range_localization") + "({0} ; {1})"));

//$.validator.addClassRules("item_edit_textbox", {required: true, messages: {required: "Введите значение."}});
//$.validator.addClassRules("bool", {required: true, hex_dec_number: true, range: [0, 1]});
$.validator.addClassRules("uint8", {required: false, hex_dec_number: true, range_localization: [0, 255]});
$.validator.addClassRules("uint16", {required: false, hex_dec_number: true, range_localization: [0, 65535]});
$.validator.addClassRules("uint32", {required: false, hex_dec_number: true, range_localization: [0, 4294967295]});
$.validator.addClassRules("uint64", {required: false, hex_dec_number: true, range_localization: [0, 18446744073709551615]});
$.validator.addClassRules("int8", {required: false, hex_dec_number: true, range_localization: [-128, 127]});
$.validator.addClassRules("int16", {required: false, hex_dec_number: true, range_localization: [-32768, 32767]});
$.validator.addClassRules("int32", {required: false, hex_dec_number: true, range_localization: [-2147483648, 2147483647]});
$.validator.addClassRules("int64", {required: false, hex_dec_number: true, range_localization: [-9223372036854775808, 9223372036854775807]});
$.validator.addClassRules("real32", {required: false, hex_dec_number: true});
$.validator.addClassRules("password", {required: false, password: true });
